--truncate table GLB_USU_AGENDA
IF EXISTS
(
    SELECT *
    FROM sys.objects
    WHERE object_id = OBJECT_ID(N'[dbo].[P_ATUALIZA_EST_PROD_AGENDA_COMPRA]')
          AND type IN(N'P', N'PC')
)
    DROP PROCEDURE [dbo].[P_ATUALIZA_EST_PROD_AGENDA_COMPRA];
GO
--agendado para data futura ou atrasado dentro do permitido, deixa a data atual
--atrasado fora do limite, calcula a data que encaixa dentro do permitido
CREATE PROCEDURE [dbo].[P_ATUALIZA_EST_PROD_AGENDA_COMPRA]
AS
SET NOCOUNT ON
		DECLARE @ajuste TABLE
			(
				 CD_EMP    INT,
				 CD_CTR_AGENDA INT,
				 FREQ_REV  INT,
				 DT_PROX   DATETIME,
				 CD_COMPRADOR INT,
				 ATRASO INT,
				 DT_BASE DATETIME,
				 QT_DIAS INT
			);

		DECLARE @hoje DATE; 
		SET @hoje=GETDATE();

		WITH ENTREGA
				 AS (--Para entregas sem periodo fechado (8,12), ha o calculo do dia da semana
						SELECT
							CD_CTR_AGENDA
							,DIA_SEMANA=2
						FROM
							EST_PROD_AGENDA_COMPRA
						WHERE
							SEGUNDA           = 1 AND
							FREQ_REV IN ( 8, 12 ) AND
							FLAG_GERAR_AGENDA = 0
						UNION ALL
						SELECT
							CD_CTR_AGENDA
							,DIA_SEMANA=3
						FROM
							EST_PROD_AGENDA_COMPRA
						WHERE
							TERCA             = 1 AND
							FREQ_REV IN ( 8, 12 ) AND
							FLAG_GERAR_AGENDA = 0
						UNION ALL
						SELECT
							CD_CTR_AGENDA
							,DIA_SEMANA=4
						FROM
							EST_PROD_AGENDA_COMPRA
						WHERE
							QUARTA            = 1 AND
							FREQ_REV IN ( 8, 12 ) AND
							FLAG_GERAR_AGENDA = 0
						UNION ALL
						SELECT
							CD_CTR_AGENDA
							,DIA_SEMANA=5
						FROM
							EST_PROD_AGENDA_COMPRA
						WHERE
							QUINTA            = 1 AND
							FREQ_REV IN ( 8, 12 ) AND
							FLAG_GERAR_AGENDA = 0
						 UNION ALL
						 SELECT
							 CD_CTR_AGENDA
							 ,DIA_SEMANA=6
						 FROM
							 EST_PROD_AGENDA_COMPRA
						 WHERE
							 SEXTA             = 1 AND
							 FREQ_REV IN ( 8, 12 ) AND
							 FLAG_GERAR_AGENDA = 0),
				 ENTREGA2
				 AS (--se nao houve dia de entrega prevista na semana, pega no semana anterior
						SELECT
							CD_CTR_AGENDA
							,DIA_SEMANA
						FROM
							ENTREGA
						 UNION ALL --semana atual: seg=2, ter=3, ..., sex=6; semana_anterior:seg=-5, ter=-4, ..., sex=-1
						 SELECT
							 CD_CTR_AGENDA
							 ,DIA_SEMANA=DIA_SEMANA - 7
						 FROM
							 ENTREGA),
				 BASE1
				 AS (--calcula o periodo se frequencia e 1,2,4 ou 28
						SELECT
							 CD_EMP=1
							 ,f.CD_CTR_AGENDA
							 ,f.FREQ_REV
							 ,DIA_SEMANA = DATEPART(WEEKDAY, @hoje)
							 ,DT_BASE = CASE WHEN FREQ_REV IN ( 1, 2, 4 ) THEN ISNULL(a.DT_AGENDA,f.DT_AGENDAMENTO_DEFAULT)
													WHEN a.DT_AGENDA > f.DT_AGENDAMENTO_DEFAULT THEN a.DT_AGENDA
													ELSE f.DT_AGENDAMENTO_DEFAULT
													END
							 ,PERIODO = CASE WHEN FREQ_REV IN ( 1, 2, 4, 28 ) THEN 28 / FREQ_REV
													END
							 ,f.CD_COMPRADOR
						 FROM
							 EST_PROD_AGENDA_COMPRA f
							 LEFT JOIN EST_PROD_AGENDA_COMPRA_AGENDAMENTO A ON
								 f.CD_CTR_AGENDA = a.CD_CTR_AGENDA
						 WHERE
							--F.INDICADOR_SUPRIMENTO = 1 AND
							f.STS_AGENDA = 0 and
							f.FLAG_GERAR_AGENDA    = 0),
				 BASE2
				 AS (--calcula o atraso, se existir; para fequencias 8,12, calcula o dia da semana da ultima entrega prevista
						SELECT
							 CD_EMP
							 ,CD_CTR_AGENDA
							 ,PERIODO
							 ,DIA_SEMANA
							 ,FREQ_REV
							 ,DT_BASE
							 ,ATRASO=DATEDIFF(DAY, DT_BASE, @hoje)
							 ,ATRASO_PERMITIDO=ISNULL(PERIODO - 1, 0)
							 ,ULT_DIA=(SELECT
													 MAX(DIA_SEMANA)
												 FROM
													 ENTREGA2 --Ultima entrega passada (dia da semana)
												 WHERE
													CD_CTR_AGENDA  = b.CD_CTR_AGENDA AND
													DIA_SEMANA <= b.DIA_SEMANA)
							,CD_COMPRADOR
						 FROM
							 BASE1 b),
				 BASE3
				 AS (SELECT
							 CD_EMP
							 ,CD_CTR_AGENDA
							 ,FREQ_REV
							 ,ATRASO
							 ,DT_BASE
							 ,QT_DIAS = CASE WHEN ATRASO <= ATRASO_PERMITIDO THEN NULL --sem atraso ou dentro do permitido, mantem data
													WHEN PERIODO IS NOT NULL THEN -ATRASO%PERIODO --dias para a proxima entrega prevista
													ELSE ULT_DIA - DIA_SEMANA
													END --idem 
							,CD_COMPRADOR
							,ATRASO_PERMITIDO
						 FROM
							 BASE2)
		INSERT INTO @ajuste
								(CD_EMP,
								 CD_CTR_AGENDA,
								 FREQ_REV,
								 DT_PROX,
								 CD_COMPRADOR,
								 ATRASO,
								 DT_BASE,
								 QT_DIAS)
		SELECT DISTINCT
			CD_EMP
			,CD_CTR_AGENDA
			,FREQ_REV 
			,DT_PROX=ISNULL(DATEADD(DAY, QT_DIAS, @hoje), DT_BASE)
			,CD_COMPRADOR
			,ATRASO
			,DT_BASE
			,QT_DIAS
		FROM
			BASE3; 

		BEGIN TRANSACTION---------------------------------------------------------------------------------------------------

		UPDATE b
		SET    [STATUS] = 2
		FROM   @ajuste a
				JOIN EST_PROD_AGENDA_COMPRA_AGENDAMENTO b ON  
				b.CD_CTR_AGENDA = a.CD_CTR_AGENDA
		WHERE
			--b.DT_AGENDA <> a.DT_PROX AND
			b.DT_AGENDA < a.DT_PROX AND
			STATUS      = 0;

		delete from a 
		from
			GLB_USU_AGENDA a
			JOIN EST_PROD_AGENDA_COMPRA_AGENDAMENTO b ON  
			b.CD_CTR_AGENDA = a.CD_CTR_AGENDA
		WHERE
			not STATUS = 0;

		INSERT INTO EST_PROD_AGENDA_COMPRA_AGENDAMENTO(CD_AGENDA,CD_CTR_AGENDA,DT_AGENDA,STATUS)
		SELECT
			 CD_AGENDA=ISNULL((SELECT MAX(CD_AGENDA) FROM EST_PROD_AGENDA_COMPRA_AGENDAMENTO WITH (XLOCK) ), 0)
								 + ROW_NUMBER() OVER (ORDER BY CD_CTR_AGENDA)
			,CD_CTR_AGENDA
			,DT_AGENDA=DT_PROX
			,STATUS=0
		FROM
			@ajuste a
		WHERE
			NOT EXISTS (SELECT 	* FROM EST_PROD_AGENDA_COMPRA_AGENDAMENTO
						WHERE 
							CD_EMP = a.CD_EMP AND 
							CD_CTR_AGENDA = a.CD_CTR_AGENDA AND
							[STATUS] = 0);
		--Alterando data agendamento Default para controle do cadastro
		UPDATE c
		SET DT_AGENDAMENTO_DEFAULT = a.DT_AGENDA
		FROM   
			EST_PROD_AGENDA_COMPRA_AGENDAMENTO a
			INNER JOIN EST_PROD_AGENDA_COMPRA c ON
			a.CD_CTR_AGENDA = c.CD_CTR_AGENDA
		WHERE
			a.STATUS = 0 AND
			c.DT_AGENDAMENTO_DEFAULT <> a.DT_AGENDA

		INSERT INTO GLB_USU_AGENDA (TITULO, COR, DT_INI, DT_FIM, URL, PARAMETROS, NAO_POSSUI_HR_INICIO_E_FIM,
										EVENT_BLOQ_EDICAO_ANTERIORMENTE,EDITAVEL,CD_USU,DT_CAD,CD_CTR_AGENDA)
		SELECT distinct
			left('AGENDA DE COMPRA '+ agd.DS_AGENDAMENTO,100) ,
			case when a.DT_PROX < convert(date,getdate()) then 
				'#ff4d4d' --Vermelho
				when a.DT_PROX = convert(date,getdate()) then  '#00cc44'	--Verde
				else
				'#0099ff' end --Azul
				,
			a.DT_PROX,
			a.DT_PROX,
			'app.compras.demanda',
			'cdEmp:'+CAST(a.CD_EMP AS VARCHAR(MAX))+' ,cdCtrAgenda:'+CAST(a.CD_CTR_AGENDA AS VARCHAR(MAX)),
			1 NAO_POSSUI_HR_INICIO_E_FIM,
			0 EVENT_BLOQ_EDICAO_ANTERIORMENTE,
			1 EDITAVEL,
			C.CD_USU_COMPRADOR,
			GETDATE() DT_CAD,
			A.CD_CTR_AGENDA
		FROM
			@ajuste a
			join EST_PROD_AGENDA_COMPRA agd on 
			a.CD_CTR_AGENDA =agd.CD_CTR_AGENDA

			INNER JOIN EST_COMPRADOR C ON
			A.CD_COMPRADOR =C.CD_COMPRADOR
			AND C.CD_EMP=1

			INNER JOIN GLB_USU U ON
			C.CD_USU_COMPRADOR = U.CD_USU
			
			LEFT JOIN GLB_USU_AGENDA UA ON
			A.CD_CTR_AGENDA = UA.CD_CTR_AGENDA 
		where 
			ua.CD_CTR is null ; 

		 
		UPDATE U
		SET COR= '#ff4d4d'--coloca agenda atrasada
		FROM 
			GLB_USU_AGENDA U
		WHERE
			DT_FIM <CONVERT (date, GETDATE())  
			AND COR <>'#ff4d4d';
				 
		COMMIT TRANSACTION---------------------------------------------------------------------------------------------------

		--Implementar auditoria
		/**********
		INSERT INTO EST_PROD_AGENDA_COMPRA_AGENDAMENTO
								(CD_EMP,
								 CD_CTR,
								 CD_OCORRENCIA,
								 CD_EVENTO,
								 CD_TP_EVENTO,
								 CD_CTR_AGENDA,
								 CD_AGENDA,
								 QTDE,
								 DT_PREV_CP,
								 CD_COMPRADOR,
								 DT_CAD)
		SELECT
			a.CD_EMP
			,CD_CTR=ISNULL((SELECT MAX(CD_CTR) FROM EST_PED_ELTR_SUPRIMENTO_AUDITORIA_AGENDA WITH (XLOCK) WHERE CD_EMP=a.CD_EMP), 0)
							+ ROW_NUMBER() OVER (PARTITION BY a.CD_EMP ORDER BY a.CD_CTR_AGENDA)
			,CD_OCORRENCIA=ISNULL((SELECT MAX(CD_OCORRENCIA) FROM EST_PED_ELTR_SUPRIMENTO_AUDITORIA_AGENDA WITH (XLOCK) WHERE CD_EMP=a.CD_EMP AND CD_AGENDA=a.CD_AGENDA), 0)
										 + ROW_NUMBER() OVER (PARTITION BY a.CD_EMP, a.CD_AGENDA ORDER BY a.CD_CTR_AGENDA)
			,CD_EVENTO=3
			,--ATRASO
			CD_TP_EVENTO=1
			,--ATRASO
			CD_CTR_AGENDA = a.CD_CTR_AGENDA
			,CD_AGENDA = a.CD_AGENDA
			,QTDE = DATEDIFF(day, a.DT_AGENDA, @hoje)
			,DT_PREV_CP = a.DT_AGENDA + f.LEAD_TIME
			,f.CD_COMPRADOR
			,DT_CAD=GETDATE()
		FROM
			EST_PED_ELTR_SUPRIMENTO_AGENDA a
			JOIN EST_PROD_AGENDA_COMPRA f ON
				f.CD_CTR_AGENDA = a.CD_CTR_AGENDA
		WHERE
			a.STATUS               = 0 AND
			a.DT_AGENDA            < @hoje AND
			f.FLAG_GERAR_AGENDA    = 0 AND
			F.INDICADOR_SUPRIMENTO = 1 AND
			NOT EXISTS --agenda atual, data com atraso e nao cadastrou hoje
					(SELECT
						 *
					 FROM
						 EST_PED_ELTR_SUPRIMENTO_AUDITORIA_AGENDA --Nao registra mais de uma vez por dia
					 WHERE
						CD_EMP    = a.CD_EMP AND
						CD_CTR_AGENDA = a.CD_CTR_AGENDA AND
						DT_CAD >= @hoje);
		*/ 